--- Function to Make VSP Vehicles Material
fn DYNFUNmakeCivilViewVehicles FUNpath =
(
  local LOCmat

  --- Open CivilViewSurfaces Material Library File
  local LOCcivilViewVehiclesMatFile = "$matlibs\\" + DYNmatNameVehicles + ".mat"
  local LOCcivilViewVehiclesMatLib  = loadTempMaterialLibrary LOCcivilViewVehiclesMatFile

  if doesFileExist LOCcivilViewVehiclesMatFile and LOCcivilViewVehiclesMatLib != undefined then
  (
    for i = 1 to LOCcivilViewVehiclesMatLib.count do
    (
      if LOCcivilViewVehiclesMatLib[i].name == DYNmatNameVehicles and classOf LOCcivilViewVehiclesMatLib[i] == Multimaterial then LOCmat = LOCcivilViewVehiclesMatLib[i]
    )
  )

  --- If It Didn't Exist In The Material Library, Create A Fresh Material Now
  if LOCmat == undefined then
  (
    LOCmat          = multiMaterial()
    LOCmat.name     = DYNmatNameVehicles
    LOCmat.count    = 27

    /* ADD DIFFUSE BODY COLOUR VARIABLES Civil View 4.1 */
    /* -------------------------------------------------- */
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourRval" "4")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourGval" "61")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourBval" "4")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourRval" "0")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourGval" "25")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourBval" "185")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourRval" "49")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourGval" "73")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourBval" "230")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourRval" "112")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourGval" "103")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourBval" "92")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourRval" "255")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourGval" "255")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourBval" "255")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourRval" "3")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourGval" "3")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourBval" "3")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourRval" "169")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourGval" "19")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourBval" "3")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourRval" "64")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourGval" "11")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourBval" "6")

    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourRval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourRval" "226")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourGval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourGval" "245")
    if (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourBval") == "" then (setINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourBval" "4")

    local LOCbodyBase1Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourRval") as integer
    local LOCbodyBase1Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourGval") as integer
    local LOCbodyBase1Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body1BaseColourBval") as integer

    local LOCbodyBase2Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourRval") as integer
    local LOCbodyBase2Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourGval") as integer
    local LOCbodyBase2Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body2BaseColourBval") as integer

    local LOCbodyBase3Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourRval") as integer
    local LOCbodyBase3Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourGval") as integer
    local LOCbodyBase3Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body3BaseColourBval") as integer

    local LOCbodyBase4Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourRval") as integer
    local LOCbodyBase4Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourGval") as integer
    local LOCbodyBase4Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body4BaseColourBval") as integer

    local LOCbodyBase5Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourRval") as integer
    local LOCbodyBase5Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourGval") as integer
    local LOCbodyBase5Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body5BaseColourBval") as integer

    local LOCbodyBase6Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourRval") as integer
    local LOCbodyBase6Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourGval") as integer
    local LOCbodyBase6Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body6BaseColourBval") as integer

    local LOCbodyBase7Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourRval") as integer
    local LOCbodyBase7Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourGval") as integer
    local LOCbodyBase7Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body7BaseColourBval") as integer

    local LOCbodyBase8Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourRval") as integer
    local LOCbodyBase8Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourGval") as integer
    local LOCbodyBase8Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body8BaseColourBval") as integer

    local LOCbodyBase9Rval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourRval") as integer
    local LOCbodyBase9Gval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourGval") as integer
    local LOCbodyBase9Bval = (GetINIsetting DYNmainINI "CivilViewVehicles Material" "Body9BaseColourBval") as integer

    --- Set Up Array of Diffuse Colours
    local LOCdiffuseCols = #() ; LOCdiffuseCols[LOCmat.count] = undefined
    LOCdiffuseCols[1]   = color LOCbodyBase1Rval LOCbodyBase1Gval LOCbodyBase1Bval
    LOCdiffuseCols[2]   = color LOCbodyBase2Rval LOCbodyBase2Gval LOCbodyBase2Bval
    LOCdiffuseCols[3]   = color LOCbodyBase3Rval LOCbodyBase3Gval LOCbodyBase3Bval
    LOCdiffuseCols[4]   = color LOCbodyBase4Rval LOCbodyBase4Gval LOCbodyBase4Bval
    LOCdiffuseCols[5]   = color LOCbodyBase5Rval LOCbodyBase5Gval LOCbodyBase5Bval
    LOCdiffuseCols[6]   = color LOCbodyBase6Rval LOCbodyBase6Gval LOCbodyBase6Bval
    LOCdiffuseCols[7]   = color LOCbodyBase7Rval LOCbodyBase7Gval LOCbodyBase7Bval
    LOCdiffuseCols[8]   = color LOCbodyBase8Rval LOCbodyBase8Gval LOCbodyBase8Bval
    LOCdiffuseCols[9]   = color LOCbodyBase9Rval LOCbodyBase9Gval LOCbodyBase9Bval
    LOCdiffuseCols[10]  = (color 73.3813 8.97469 8.97469)
    LOCdiffuseCols[11]  = (color 145.805 145.805 146.763)
    LOCdiffuseCols[12]  = (color 22.0144 22.0144 22.0144)
    LOCdiffuseCols[13]  = (color 3 3 3)
    LOCdiffuseCols[14]  = (color 233.07 233.07 234.6)
    LOCdiffuseCols[15]  = (color 0 0 0)
    LOCdiffuseCols[16]  = (color 9.17266 8.2488 8.2488)
    LOCdiffuseCols[17]  = (color 0 0 0)
    LOCdiffuseCols[18]  = (color 120 120 120)
    LOCdiffuseCols[19]  = (color 177.857 142.03 49.9023)
    LOCdiffuseCols[20]  = (color 102.734 12.3281 0)
    LOCdiffuseCols[21]  = (color 185.272 192.626 8.77101) 
    LOCdiffuseCols[22]  = (color 185.272 192.626 8.77101) 
    LOCdiffuseCols[23]  = (color 223.813 220.467 212.659) 
    LOCdiffuseCols[24]  = (color 174 174 174)
    LOCdiffuseCols[25]  = (color 177.857 142.03 49.9023)
    LOCdiffuseCols[26]  = (color 20.1799 18.1474 18.1474)
    LOCdiffuseCols[27]  = (color 157.5 157.5 157.5 267.75)

    LOCmat[1]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[1]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[1]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[2]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[2]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[2]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[3]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[3]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[3]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[4]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[4]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[4]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[5]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[5]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[5]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[6]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[6]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[6]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[7]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[7]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[7]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[8]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[8]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[8]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[9]  = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[9]  1.0 (color 206 206 206) 0.1  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[9]  0.0 1.0 (color 20 24 103) 0.4 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) false 0.05 1.0 1.76 1.0 0.0 0 0
    LOCmat[10] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[10] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[10] 0.0 1.0 (color 255 255 255) 0.52 false 0.0 1.4 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[11] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[11] 0.0 (color 206 206 206) 0.0  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[11] 0.0 1.0 (color 255 255 255) 0.51 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.01 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.05 1.0 5.0 1.0 0.0 0 0
    LOCmat[12] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[12] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[12] 0.0 1.0 (color 255 255 255) 0.52 false 0.0 1.4 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[13] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[13] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[13] 0.0 1.0 (color 255 255 255) 0.52 false 0.0 1.4 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[14] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[14] 0.0 (color 206 206 206) 0.0  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[14] 0.0 1.0 (color 255 255 255) 0.29 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.05 1.0 5.0 1.0 0.0 0 0
    LOCmat[15] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[15] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[15] 1.0 0.59 (color 255 255 255) 0.630481 false 0.0 1.52 0.0 (color 255 255 255) 1.0 true false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.25 0.5 5.0 1.0 0.0 0 0
    LOCmat[16] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[16] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[16] 1.0 0.59 (color 255 255 255) 0.630481 false 0.0 1.52 0.0 (color 255 255 255) 1.0 true false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.25 0.5 5.0 1.0 0.0 0 0
    LOCmat[17] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[17] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[17] 0.0 1.0 (color 255 255 255) 0.0 false 0.0 1.5 0.7 (color 122.364 134.13 139.424) 0.0 false true 0.001 true 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.25 0.5 5.0 1.0 0.0 0 0
    LOCmat[18] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[18] 1.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[18] 0.5 1.0 (color 153 153 153) 0.6 false 0.0 10.0 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[19] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[19] 1.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[19] 0.5 1.0 (color 176.115 172.663 116.565) 0.6 false 0.0 10.0 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[20] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[20] 1.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[20] 0.5 1.0 (color 174.281 11.9447 11.9447) 0.4 false 0.0 10.0 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[21] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[21] 0.0 (color 206 206 206) 0.0  false 0.0 0.0 1.5  0.7 LOCdiffuseCols[21] 0.0 1.0 (color 255 255 255) 0.6 false 0.0 1.48 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.05 1.0 5.0 1.0 0.0 0 0
    LOCmat[22] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[22] 0.0 (color 206 206 206) 0.0  false 0.0 0.0 1.5  0.7 LOCdiffuseCols[22] 0.0 1.0 (color 255 255 255) 0.6 false 0.0 1.48 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.05 1.0 5.0 1.0 0.0 0 0
    LOCmat[23] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[23] 0.0 (color 206 206 206) 0.0  false 0.0 0.0 1.5  1.0 LOCdiffuseCols[23] 0.0 1.0 (color 255 255 255) 0.0 false 1.0 1.52 0.0 (color 255 255 255) 1.0 true true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.05 1.0 5.0 1.0 0.0 0 0
    LOCmat[24] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[24] 1.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[24] 0.5 1.0 (color 153 153 153) 0.6 false 0.0 10.0 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.4 (color 255 255 255) 1500.0 5200.0 (color 912.681 786.078 621.272) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[25] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[25] 1.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[25] 0.5 1.0 (color 176.115 172.663 116.565) 0.6 false 0.0 10.0 0.0 (color 255 255 255) 1.0 false false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.4 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0
    LOCmat[26] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[26] 0.0 (color 255 255 255) 0.12 false 0.5 0.5 1.5  1.0 LOCdiffuseCols[26] 1.0 0.59 (color 255 255 255) 0.630481 false 0.0 1.52 0.0 (color 255 255 255) 1.0 true false 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.25 0.5 5.0 1.0 0.0 0 0
    LOCmat[27] = DYNFUNsetPhysicalMaterialBasics DYNuiResourcesMaterials[27] 0.0 (color 255 255 255) 0.0  false 0.5 0.5 1.52 1.0 LOCdiffuseCols[27] 0.2 0.0 (color 255 255 255) 0.0 false 0.0 1.52 0.0 (color 255 255 255) 0.0 false true 0.0 false 0.0 (color 255 255 255) 10.0 1.0 (color 255 127.5 63.75) 0.0 (color 255 255 255) 1500.0 6500.0 (color 801.106 801.106 801.106) true 0.2 1.0 5.0 1.0 0.0 0 0

    --- Set Names In MultiMaterial
    for i = 1 to LOCmat.count do
    (
      LOCmat.names[i] = LOCmat.materialList[i].name
    )

    --- Attempt to Save Material To Civil View Material Library
    local LOCmatLibrary = materialLibrary LOCmat
    local LOCsuccess    = saveTempMaterialLibrary LOCmatLibrary LOCcivilViewVehiclesMatFile
  )

  --- Show Texture Maps In Viewport
  if classOf LOCmat == Multimaterial then (for i = 1 to LOCmat.count do (DYNFUNshowTextureMap LOCmat i false on))

  LOCmat -- return value
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCJVzYt26nQNo7zANnxKDvnww2pWrtQJakp
-- DE/O1h6wO0Mj/t3hUbRE+0a3RYuOyrArtY8p0pAHliUZm3VnzPiDADsWIAk9D71D
-- lfOojq1I8xWhJV+jmiM6IsOI3Yvw1ssvvKK8mahxBWb0ADPz/QqUKIKYnwKn5EEQ
-- 6xQi3fKlKEmuDDjO4V6ksHJ29qdiPAyDmGDWNXH9zv9JTo/oFSva7fWZK7RB9TOj
-- SFx99xx8l/LYy/sar4QnYzqQWKyLoFvj9IBwNZiWoomp/5MDiw7wT7goNUS6oyrf
-- yUYrme4Y8OZ49SppyQBJVcXE/ZPxm0PaI40cnK/aOFSsa7Xfsc7r
-- -----END-SIGNATURE-----